/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.script;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.script.GuiScriptClient;
import noppes.npcs.client.gui.script.GuiScriptEncrypt;
import noppes.npcs.client.gui.script.GuiScriptList;
import noppes.npcs.client.gui.util.GuiButtonBiDirectional;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiMenuTopButton;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiTextArea;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.ITextChangeListener;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.ClientScriptData;
import noppes.npcs.reflection.nbt.TagLongArrayReflection;
import noppes.npcs.util.Util;

public class GuiScriptInterface
extends GuiNPCInterface
implements IGuiData,
ITextChangeListener {
    private static final String web_site = "http://www.kodevelopment.nl/minecraft/customnpcs/scripting";
    private static final String api_doc_site = "https://github.com/BetaZavr/CustomNPCsAPI-Unofficial";
    private static final String api_site = "https://github.com/BetaZavr/CustomNPCsAPI-Unofficial";
    private static final String dis_site = "https://discord.gg/RGb4JqE6Qz";
    protected int activeTab;
    protected final Map<Integer, Long> dataLog = new HashMap<Integer, Long>();
    protected Long selectLog = 0L;
    public IScriptHandler handler;
    public Map<String, Map<String, Long>> languages = new HashMap<String, Map<String, Long>>();
    public String path;
    public String ext;
    protected boolean wait = true;

    public GuiScriptInterface() {
        this.drawDefaultBackground = true;
        this.closeOnEsc = true;
        this.setBackground("menubg.png");
        this.activeTab = 0;
    }

    @Override
    protected void func_146284_a(@Nonnull GuiButton button) {
        GuiYesNo guiyesno;
        ScriptContainer container;
        if (this.wait) {
            return;
        }
        if (button.field_146127_k >= 0 && button.field_146127_k < CustomNpcs.ScriptMaxTabs) {
            this.setScript();
            this.activeTab = button.field_146127_k;
            this.func_73866_w_();
        }
        if (button.field_146127_k == CustomNpcs.ScriptMaxTabs + 1) {
            if (this.handler.getScripts().size() >= CustomNpcs.ScriptMaxTabs) {
                this.activeTab = CustomNpcs.ScriptMaxTabs;
                this.func_73866_w_();
                return;
            }
            this.handler.getScripts().add(new ScriptContainer(this.handler, true));
            this.activeTab = this.handler.getScripts().size();
            this.func_73866_w_();
        }
        if (button.field_146127_k == 100) {
            if (this.activeTab == 0) {
                TreeMap<Long, String> map = this.handler.getConsoleText();
                StringBuilder builder = new StringBuilder();
                for (Map.Entry entry : map.entrySet()) {
                    builder.insert(0, new Date((Long)entry.getKey()) + (String)entry.getValue() + "\n\n");
                }
                NoppesStringUtils.setClipboardContents(builder.toString());
            } else {
                NoppesStringUtils.setClipboardContents(((GuiTextArea)this.get(2, GuiTextArea.class)).getFullText());
            }
        }
        if (button.field_146127_k == 101) {
            container = this.handler.getScripts().get(this.activeTab - 1);
            if (container != null) {
                boolean sr;
                boolean bl = sr = container.script != null && !container.script.isEmpty();
                if (sr) {
                    String tempScript = container.script.replace(" ", "").replace("\t", "").replace("\n", "");
                    boolean bl2 = sr = !tempScript.isEmpty();
                }
                if (sr) {
                    GuiYesNo guiyesno2 = new GuiYesNo((GuiYesNoCallback)this, "", new TextComponentTranslation("gui.replaceMessage", new Object[0]).func_150254_d(), 6);
                    this.displayGuiScreen((GuiScreen)guiyesno2);
                    return;
                }
            }
            this.getTextArea(2).setFullText(NoppesStringUtils.getClipboardContents());
        }
        if (button.field_146127_k == 102) {
            if (this.activeTab > 0) {
                guiyesno = new GuiYesNo((GuiYesNoCallback)this, "", new TextComponentTranslation("gui.deleteMessage", new Object[0]).func_150254_d(), 5);
                this.displayGuiScreen((GuiScreen)guiyesno);
            } else {
                this.handler.clearConsole();
            }
            this.func_73866_w_();
        }
        if (button.field_146127_k == 103) {
            this.handler.setLanguage(button.field_146126_j);
            String[] data = GuiScriptInterface.getLanguageData(button.field_146126_j);
            ((GuiNpcButton)button).setHoverText(new TextComponentTranslation("script.hover.info." + data[0], new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("script.hover.info.dir", new Object[]{data[1], data[2]})).func_150254_d(), new Object[0]);
        }
        if (button.field_146127_k == 104) {
            this.handler.setEnabled(((GuiNpcButton)button).getValue() == 1);
        }
        if (button.field_146127_k == 105) {
            guiyesno = new GuiYesNo((GuiYesNoCallback)this, "", new TextComponentTranslation("gui.deleteMessage", new Object[0]).func_150254_d(), 10);
            this.displayGuiScreen((GuiScreen)guiyesno);
        }
        if (button.field_146127_k == 106) {
            NoppesUtil.openFolder(ScriptController.Instance.dir);
        }
        if (button.field_146127_k == 107) {
            container = this.handler.getScripts().get(this.activeTab - 1);
            if (container == null) {
                container = new ScriptContainer(this.handler, true);
                this.handler.getScripts().add(container);
            }
            this.setSubGui(new GuiScriptList(this.languages.get(Util.instance.deleteColor(this.handler.getLanguage())), container));
        }
        if (button.field_146127_k == 108 && (container = this.handler.getScripts().get(this.activeTab - 1)) != null) {
            this.setScript();
        }
        if (button.field_146127_k == 109) {
            this.displayGuiScreen((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, web_site, 0, true));
        }
        if (button.field_146127_k == 110) {
            this.displayGuiScreen((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, "https://github.com/BetaZavr/CustomNPCsAPI-Unofficial", 1, true));
        }
        if (button.field_146127_k == 111) {
            this.displayGuiScreen((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, "https://github.com/BetaZavr/CustomNPCsAPI-Unofficial", 2, true));
        }
        if (button.field_146127_k == 112) {
            this.displayGuiScreen((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, dis_site, 3, true));
        }
        if (button.field_146127_k == 115) {
            guiyesno = new GuiYesNo((GuiYesNoCallback)this, new TextComponentTranslation("gui.remove.all", new Object[0]).func_150254_d(), new TextComponentTranslation("gui.deleteMessage", new Object[0]).func_150254_d(), 4);
            this.displayGuiScreen((GuiScreen)guiyesno);
        }
        if (button.field_146127_k == 118 && (container = this.handler.getScripts().get(this.activeTab - 1)) != null) {
            this.setSubGui(new GuiScriptEncrypt(this.path, this.ext));
        }
        if (button.field_146127_k == 119) {
            if (this.activeTab > 0 || this.get(2, GuiTextArea.class) == null || !this.dataLog.containsKey(((GuiNpcButton)button).getValue()) || !this.handler.getConsoleText().containsKey(this.dataLog.get(((GuiNpcButton)button).getValue()))) {
                return;
            }
            this.selectLog = this.dataLog.get(((GuiNpcButton)button).getValue());
            ((GuiTextArea)this.get(2, GuiTextArea.class)).setFullText(new Date(this.selectLog) + this.handler.getConsoleText().get(this.selectLog));
        }
        if (button.field_146127_k == 120) {
            if (this.activeTab > 0) {
                return;
            }
            NoppesStringUtils.setClipboardContents(this.getTextArea(2).getFullText());
        }
        if (button.field_146127_k == 121) {
            if (this.activeTab > 0) {
                return;
            }
            this.handler.clearConsoleText(this.selectLog);
            this.func_73866_w_();
        }
    }

    public void func_73878_a(boolean flag, int i) {
        if (flag) {
            if (i == 0) {
                this.openLink(web_site);
            } else if (i == 1) {
                this.openLink("https://github.com/BetaZavr/CustomNPCsAPI-Unofficial");
            } else if (i == 2) {
                this.openLink("https://github.com/BetaZavr/CustomNPCsAPI-Unofficial");
            } else if (i == 3) {
                this.openLink(dis_site);
            } else if (i == 4) {
                this.handler.getScripts().clear();
                this.activeTab = 0;
            } else if (i == 5) {
                ScriptContainer container = this.handler.getScripts().get(this.activeTab - 1);
                container.script = "";
            } else if (i == 6) {
                this.getTextArea(2).setFullText(NoppesStringUtils.getClipboardContents());
            } else if (i == 10) {
                this.handler.getScripts().remove(this.activeTab - 1);
                this.activeTab = 0;
            }
        }
        this.displayGuiScreen(this);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.field_146297_k.field_71441_e.func_82737_E() % 5L == 0L) {
            if (this.activeTab > 0) {
                boolean e;
                ScriptContainer container = this.handler.getScripts().get(this.activeTab - 1);
                boolean bl = e = container == null || container.script.isEmpty();
                if (this.getButton(100) != null) {
                    if (this.getButton(100).isEnabled() && e) {
                        this.getButton(100).setEnabled(false);
                    } else if (!this.getButton(100).isEnabled() && !e) {
                        this.getButton(100).setEnabled(true);
                    }
                }
                if (this.getButton(102) != null) {
                    if (this.getButton(102).isEnabled() && e) {
                        this.getButton(102).setEnabled(false);
                    } else if (!this.getButton(102).isEnabled() && !e) {
                        this.getButton(102).setEnabled(true);
                    }
                }
                if (this.getButton(118) != null) {
                    this.getButton(118).setEnabled(container != null && container.hasNoEncryptScriptCode());
                }
                if (this.getButton(107) != null) {
                    Map<String, Long> map = this.languages.get(Util.instance.deleteColor(this.handler.getLanguage()));
                    boolean bl2 = e = map != null && !map.isEmpty();
                    if (this.getButton(107).isEnabled() && !e) {
                        this.getButton(107).setEnabled(false);
                    } else if (!this.getButton(107).isEnabled() && e) {
                        this.getButton(107).setEnabled(true);
                    }
                }
                if (this.getButton(101) != null) {
                    try {
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        Transferable contents = clipboard.getContents(null);
                        boolean bl3 = e = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
                        if (this.getButton(101).isEnabled() && !e) {
                            this.getButton(101).setEnabled(false);
                        } else if (!this.getButton(101).isEnabled() && e) {
                            this.getButton(101).setEnabled(true);
                        }
                    }
                    catch (Exception ee) {
                        LogWriter.error(ee);
                    }
                }
            } else {
                boolean e;
                boolean bl = e = this.handler == null || this.handler.getConsoleText().isEmpty();
                if (this.getButton(100) != null) {
                    if (this.getButton(100).isEnabled() && e) {
                        this.getButton(100).setEnabled(false);
                    } else if (!this.getButton(100).isEnabled() && !e) {
                        this.getButton(100).setEnabled(true);
                    }
                }
                if (this.getButton(102) != null) {
                    if (this.getButton(102).isEnabled() && e) {
                        this.getButton(102).setEnabled(false);
                    } else if (!this.getButton(102).isEnabled() && !e) {
                        this.getButton(102).setEnabled(true);
                    }
                }
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private static String[] getLanguageData(String name) {
        String key = "ecmascript";
        String ext = ".js";
        if (name.toLowerCase().startsWith("graaljs")) {
            key = "graaljs";
        } else if (name.toLowerCase().startsWith("luaj")) {
            key = "lua";
            ext = ".lua";
        } else if (name.toLowerCase().startsWith("jython")) {
            key = "jython";
            ext = ".py";
        } else if (name.toLowerCase().startsWith("jruby")) {
            key = "jruby";
            ext = ".rb";
        } else if (name.toLowerCase().startsWith("groovy")) {
            key = "groovy";
            ext = ".groovy";
        } else if (name.toLowerCase().startsWith("kotlin")) {
            key = "kotlin";
            ext = ".kt";
        } else if (name.toLowerCase().startsWith("rhino")) {
            key = "rhino";
        }
        String dir = "./(world_name)/customnpcs/scripts/" + name.toLowerCase();
        if (CustomNpcs.Server != null) {
            dir = CustomNpcs.getWorldSaveDirectory().getAbsolutePath().replace("\\", "/");
            if (dir.lastIndexOf("/./") != -1) {
                dir = dir.substring(dir.lastIndexOf("/./") + 1);
            }
            dir = dir + "/scripts/" + name.toLowerCase();
        }
        return new String[]{key, dir, ext};
    }

    private int getScriptIndex() {
        int i = 0;
        for (String language : this.languages.keySet()) {
            if (Util.instance.equalsDeleteColor(language, this.handler.getLanguage(), true)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.wait = false;
        this.xSize = (int)((double)this.field_146294_l * 0.88);
        this.ySize = (int)((double)this.field_146295_m * 0.9);
        super.func_73866_w_();
        this.guiTop += 10;
        int y = this.guiTop + 5;
        GuiMenuTopButton top = new GuiMenuTopButton(0, this.guiLeft + 4, this.guiTop - 17, "gui.settings");
        this.addTopButton(top);
        for (int i = 0; i < this.handler.getScripts().size(); ++i) {
            top = new GuiMenuTopButton(i + 1, top, i + 1 + "");
            this.addTopButton(top);
        }
        if (this.handler.getScripts().size() < CustomNpcs.ScriptMaxTabs && !(this.handler instanceof ClientScriptData)) {
            this.addTopButton(new GuiMenuTopButton(CustomNpcs.ScriptMaxTabs + 1, top, "+"));
        }
        if ((top = (GuiMenuTopButton)this.getTopButton(this.activeTab)) == null) {
            this.activeTab = 0;
            top = (GuiMenuTopButton)this.getTopButton(0);
        }
        top.active = true;
        if (this.activeTab > 0) {
            ScriptContainer container = this.handler.getScripts().get(this.activeTab - 1);
            GuiTextArea ta = new GuiTextArea(2, this.guiLeft + 5, y, this.xSize - 132, this.ySize - 10, container == null ? "" : container.script);
            ta.enableCodeHighlighting();
            ta.setListener(this);
            this.add(ta);
            int x = this.guiLeft + 7 + ta.width;
            this.addButton(new GuiNpcButton(102, x, y, 60, 20, "gui.clear"));
            this.addButton(new GuiNpcButton(101, x + 61, y, 60, 20, "gui.paste"));
            this.addButton(new GuiNpcButton(100, x, y + 21, 60, 20, "gui.copy"));
            this.addButton(new GuiNpcButton(105, x + 61, y + 21, 60, 20, "gui.remove"));
            this.addButton(new GuiNpcButton(107, x, y + 66, 80, 20, "script.loadscript"));
            this.addButton(new GuiNpcButton(115, x + 30, y + 43, 60, 20, "gui.remove.all"));
            GuiCustomScroll scroll = (GuiCustomScroll)new GuiCustomScroll(this, 0).setUnSelectable();
            scroll.setSize(120, this.ySize - 120);
            scroll.guiLeft = x;
            scroll.guiTop = y = this.guiTop + 93;
            if (container != null) {
                scroll.setList(container.scripts);
            }
            this.addScroll(scroll);
            GuiNpcButton button = new GuiNpcButton(118, x, y + 2 + scroll.field_146295_m, 80, 20, "gui.encrypt");
            this.addButton(button);
            button.setEnabled(!(this instanceof GuiScriptClient));
            button.setHoverText("" + button.field_146124_l, new Object[0]);
        } else {
            NavigableMap<Long, String> map = this.handler.getConsoleText().descendingMap();
            String log = "";
            if (!map.isEmpty()) {
                if (!map.containsKey(this.selectLog)) {
                    Iterator x = map.keySet().iterator();
                    while (x.hasNext()) {
                        long time = (Long)x.next();
                        if (this.selectLog >= time) continue;
                        this.selectLog = time;
                    }
                }
                log = new Date(this.selectLog) + (String)map.get(this.selectLog);
            }
            GuiTextArea ta = new GuiTextArea(2, this.guiLeft + 5, y, this.xSize - 175, this.ySize - 10, log);
            if (!map.isEmpty()) {
                ta.y += 24;
                ta.height -= 24;
            }
            ta.enabled = false;
            this.add(ta);
            int x = this.guiLeft + 7 + ta.width;
            GuiNpcButton button = new GuiNpcButton(100, x, this.guiTop + 125, 60, 20, map.size() < 2 ? "gui.copy" : new TextComponentTranslation("gui.copy", new Object[0]).func_150254_d() + " " + new TextComponentTranslation("gui.all", new Object[0]).func_150254_d());
            this.addButton(button);
            button.setHoverText("script.hover.log.copy.all", new Object[0]);
            button = new GuiNpcButton(102, x, this.guiTop + 146, 60, 20, map.size() < 2 ? "gui.clear" : new TextComponentTranslation("gui.clear", new Object[0]).func_150254_d() + " " + new TextComponentTranslation("gui.all", new Object[0]).func_150254_d());
            this.addButton(button);
            button.setHoverText("script.hover.log.clear.all", new Object[0]);
            if (map.size() > 1) {
                ArrayList<String> selects = new ArrayList<String>();
                this.dataLog.clear();
                int i = 0;
                int pos = 0;
                for (Long key : map.keySet()) {
                    this.dataLog.put(i, key);
                    if (Objects.equals(key, this.selectLog)) {
                        pos = i;
                    }
                    selects.add(i + 1 + "/" + map.size() + ": " + new Date(key));
                    ++i;
                }
                this.addButton(new GuiButtonBiDirectional(119, this.guiLeft + 4, this.guiTop + 7, ta.width, 20, selects.toArray(new String[0]), pos));
                if (map.size() > 1) {
                    this.getButton(100).setLeft(x + 62);
                    this.getButton(102).setLeft(x + 62);
                    button = new GuiNpcButton(120, x, this.guiTop + 125, 60, 20, "gui.copy");
                    this.addButton(button);
                    button.setHoverText("script.hover.log.copy", new Object[0]);
                    button = new GuiNpcButton(121, x, this.guiTop + 146, 60, 20, "gui.clear");
                    this.addButton(button);
                    button.setHoverText("script.hover.log.clear", new Object[0]);
                }
            }
            this.addLabel(new GuiNpcLabel(1, "script.language", x + 1, this.guiTop + 15));
            String[] ls = this.languages.keySet().toArray(new String[0]);
            if (ls.length < 1) {
                this.addButton(new GuiNpcButton(103, x + 60, this.guiTop + 10, 80, 20, ls, this.getScriptIndex()));
            } else {
                this.addButton(new GuiButtonBiDirectional(103, x + 60, this.guiTop + 10, 80, 20, ls, this.getScriptIndex()));
            }
            this.getButton(103).setEnabled(!this.languages.isEmpty());
            String[] data = GuiScriptInterface.getLanguageData(this.getButton(103).getDisplayString());
            this.getButton(103).setHoverText(new TextComponentTranslation("script.hover.info." + data[0], new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("script.hover.info.dir", new Object[]{data[1], data[2]})).func_150254_d(), new Object[0]);
            this.addLabel(new GuiNpcLabel(3, "[?]", x + 145, this.guiTop + 15));
            this.getLabel(3).setHoverText("script.hover.info", new Object[0]);
            this.addLabel(new GuiNpcLabel(2, "gui.enabled", x + 1, this.guiTop + 36));
            this.addButton(new GuiNpcButton(104, x + 60, this.guiTop + 31, 50, 20, new String[]{"gui.no", "gui.yes"}, this.handler.getEnabled() ? 1 : 0));
            if (this.player.func_184102_h() != null) {
                this.addButton(new GuiNpcButton(106, x, this.guiTop + 55, 150, 20, "script.openfolder"));
            }
            this.addButton(new GuiNpcButton(109, x, this.guiTop + 78, 80, 20, "gui.website"));
            this.addButton(new GuiNpcButton(112, x + 81, this.guiTop + 78, 80, 20, "gui.forum"));
            this.addButton(new GuiNpcButton(110, x, this.guiTop + 99, 80, 20, "script.apidoc"));
            this.addButton(new GuiNpcButton(111, x + 81, this.guiTop + 99, 80, 20, "script.apisrc"));
        }
        if (this.getButton(1) != null && this.getButton(1).isHovered()) {
            this.setHoverText("animation.hover.anim.del", new Object[0]);
        }
    }

    @Override
    public void save() {
        this.setScript();
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        NBTTagList data = compound.func_150295_c("Languages", 10);
        this.languages.clear();
        for (int i = 0; i < data.func_74745_c(); ++i) {
            NBTTagCompound comp = data.func_150305_b(i);
            TreeMap<String, Long> scripts = new TreeMap<String, Long>();
            NBTTagList list = comp.func_150295_c("Scripts", 8);
            long[] ld = new long[list.func_74745_c()];
            if (comp.func_150297_b("sizes", 12)) {
                ld = TagLongArrayReflection.getData((NBTTagLongArray)comp.func_74781_a("sizes"));
            }
            if (ld != null) {
                for (int j = 0; j < list.func_74745_c(); ++j) {
                    scripts.put(list.func_150307_f(j), ld[j]);
                }
            }
            this.languages.put(comp.func_74779_i("Language"), scripts);
            if (!Util.instance.equalsDeleteColor(comp.func_74779_i("Language"), this.handler.getLanguage(), false)) continue;
            this.ext = comp.func_74779_i("FileSfx");
        }
        this.path = compound.func_74779_i("DirPath") + "/" + this.handler.getLanguage().toLowerCase();
        this.func_73866_w_();
    }

    private void setScript() {
        if (this.activeTab > 0) {
            ScriptContainer container = this.handler.getScripts().get(this.activeTab - 1);
            if (container == null) {
                container = new ScriptContainer(this.handler, true);
                this.handler.getScripts().add(container);
            }
            String text = this.getTextArea(2).getFullText();
            text = text.replace("\r\n", "\n");
            container.script = text = text.replace("\r", "\n");
        }
    }

    @Override
    public void textUpdate(String text) {
        ScriptContainer container = this.handler.getScripts().get(this.activeTab - 1);
        if (container != null) {
            container.script = text;
        }
    }

    public void addScript(int tab, String codePart) {
        if (tab < 0) {
            return;
        }
        List<ScriptContainer> scripts = this.handler.getScripts();
        while (tab >= scripts.size()) {
            scripts.add(new ScriptContainer(this.handler, true));
        }
        ScriptContainer container = scripts.get(tab);
        if (container.script == null || codePart.isEmpty()) {
            container.script = "";
            if (codePart.isEmpty()) {
                return;
            }
        }
        container.script = container.script + codePart;
    }

    public void addConsole(int tab, long time, String consolePart) {
        if (tab < 0) {
            return;
        }
        List<ScriptContainer> scripts = this.handler.getScripts();
        while (tab >= scripts.size()) {
            scripts.add(new ScriptContainer(this.handler, true));
        }
        ScriptContainer container = scripts.get(tab);
        if (container.console == null) {
            container.console = new TreeMap();
        }
        if (!container.console.containsKey(time) || consolePart.isEmpty()) {
            container.console.put(time, "");
        }
        String consoleText = container.console.get(time) + consolePart;
        container.console.put(time, consoleText);
    }
}

